/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.Property;
import org.betterx.bclib.api.v3.datagen.DropSelfLootProvider;
import org.betterx.bclib.behaviours.BehaviourHelper;
import org.betterx.bclib.behaviours.interfaces.BehaviourMetal;
import org.betterx.bclib.behaviours.interfaces.BehaviourStone;
import org.betterx.bclib.behaviours.interfaces.BehaviourWood;
import org.betterx.bclib.client.models.BasePatterns;
import org.betterx.bclib.client.models.ModelsHelper;
import org.betterx.bclib.client.models.PatternsHelper;
import org.betterx.bclib.interfaces.BlockModelProvider;
import org.betterx.bclib.interfaces.TagProvider;
import org.jetbrains.annotations.Nullable;

public abstract class BaseButtonBlock
extends ButtonBlock
implements BlockModelProvider,
TagProvider,
DropSelfLootProvider<BaseButtonBlock> {
    private final Block parent;

    protected BaseButtonBlock(Block parent, BlockBehaviour.Properties properties, boolean sensitive, BlockSetType type) {
        this(parent, properties, 30, sensitive, type);
    }

    protected BaseButtonBlock(Block parent, BlockBehaviour.Properties properties, int ticksToStayPressed, boolean sensitive, BlockSetType type) {
        super(properties.m_60910_(), type, ticksToStayPressed, sensitive);
        this.parent = parent;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public BlockModel getItemModel(ResourceLocation blockId) {
        ResourceLocation parentId = BuiltInRegistries.f_256975_.m_7981_((Object)this.parent);
        Optional<String> pattern = PatternsHelper.createJson(BasePatterns.ITEM_BUTTON, parentId);
        return ModelsHelper.fromPattern(pattern);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    @Nullable
    public BlockModel getBlockModel(ResourceLocation resourceLocation, BlockState blockState) {
        ResourceLocation parentId = BuiltInRegistries.f_256975_.m_7981_((Object)this.parent);
        Optional<String> pattern = (Boolean)blockState.m_61143_((Property)f_51045_) != false ? PatternsHelper.createJson(BasePatterns.BLOCK_BUTTON_PRESSED, parentId) : PatternsHelper.createJson(BasePatterns.BLOCK_BUTTON, parentId);
        return ModelsHelper.fromPattern(pattern);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public UnbakedModel getModelVariant(ResourceLocation stateId, BlockState blockState, Map<ResourceLocation, UnbakedModel> modelCache) {
        String powered = (Boolean)blockState.m_61143_((Property)f_51045_) != false ? "_powered" : "";
        ResourceLocation modelId = new ResourceLocation(stateId.m_135827_(), "block/" + stateId.m_135815_() + powered);
        this.registerBlockModel(stateId, modelId, blockState, modelCache);
        AttachFace face = (AttachFace)blockState.m_61143_((Property)f_53179_);
        boolean isCeiling = face == AttachFace.CEILING;
        int x = 0;
        int y = 0;
        switch (face) {
            case CEILING: {
                x = 180;
                break;
            }
            case WALL: {
                x = 90;
                break;
            }
        }
        switch ((Direction)blockState.m_61143_((Property)f_54117_)) {
            case NORTH: {
                if (!isCeiling) break;
                y = 180;
                break;
            }
            case EAST: {
                y = isCeiling ? 270 : 90;
                break;
            }
            case SOUTH: {
                if (isCeiling) break;
                y = 180;
                break;
            }
            case WEST: {
                y = isCeiling ? 90 : 270;
                break;
            }
        }
        BlockModelRotation rotation = BlockModelRotation.m_119153_((int)x, (int)y);
        return ModelsHelper.createMultiVariant(modelId, rotation.m_6189_(), face == AttachFace.WALL);
    }

    @Override
    public void addTags(List<TagKey<Block>> blockTags, List<TagKey<Item>> itemTags) {
        blockTags.add((TagKey<Block>)BlockTags.f_13093_);
        itemTags.add((TagKey<Item>)ItemTags.f_13171_);
    }

    public static BaseButtonBlock from(Block source, BlockSetType type) {
        return BehaviourHelper.from(source, type, Wood::new, Stone::new, Metal::new);
    }

    public static class Wood
    extends BaseButtonBlock
    implements BehaviourWood {
        public Wood(Block source, BlockSetType type) {
            super(source, BlockBehaviour.Properties.m_60926_((BlockBehaviour)source).m_60913_(0.5f, 0.5f).m_60955_(), true, type);
        }

        @Override
        public void addTags(List<TagKey<Block>> blockTags, List<TagKey<Item>> itemTags) {
            super.addTags(blockTags, itemTags);
            blockTags.add((TagKey<Block>)BlockTags.f_13092_);
            itemTags.add((TagKey<Item>)ItemTags.f_13170_);
        }
    }

    public static class Stone
    extends BaseButtonBlock
    implements BehaviourStone {
        public Stone(Block source, BlockSetType type) {
            super(source, BlockBehaviour.Properties.m_60926_((BlockBehaviour)source).m_60955_(), false, type);
        }

        @Override
        public void addTags(List<TagKey<Block>> blockTags, List<TagKey<Item>> itemTags) {
            super.addTags(blockTags, itemTags);
            blockTags.add((TagKey<Block>)BlockTags.f_279568_);
            itemTags.add((TagKey<Item>)ItemTags.f_279629_);
        }
    }

    public static class Metal
    extends BaseButtonBlock
    implements BehaviourMetal {
        public Metal(Block source, BlockSetType type) {
            super(source, BlockBehaviour.Properties.m_60926_((BlockBehaviour)source).m_60955_(), false, type);
        }
    }
}

